#pragma once

#include "rect.h"
#include "tri.h"

class Application
{
private:
	int state;
	int userKeyPress;

	/** what shape is selected */
	int selectedIndex;
	/** address to the selected object */
	void * selected;
	/** type of the selected object */
	int selectedType;
	/** which type the "selected" pointer could be pointed at */
	static const int TYPE_RECT = 1, TYPE_TRI = 2;
	int numShapes;
public:
	static const int NUM_RECT = 3, NUM_TRI = 2;
	Rect * rectangles[NUM_RECT];
	Tri * triangles[NUM_TRI];

	static const int 
		STATE_INIT = 0,    // an application not yet fully initialized
		STATE_RUNNING = 1, // running
		STATE_QUIT = 2;    // user requested quit

	/** @return Application::STATE_* */
	int getState(){ return state; }

	Application():state(STATE_INIT){}

	void init();
	void release();

	void draw();
	void setUserInput(int input);
	void update();
};
